** Roman Roads to Prosperity: Persistence and Non-Persistence of Public Infrastructure
** Carl-Johan Dalgaard, Nicolai Kaarsen, Ola Olsson, Pablo Selaya
** Journal of Comparative Economics, 2022

** Spatial correlation analysis
** Figures A3, A4, A5


***********************************************************
* Before running the do-file, make sure to install:       *
* ssc install acreg                                       *
* ssc install fsum                                        *
* ssc install bisncatter                                  *
* ssc install hdfe                                        *
* ssc install ranktest                                    *
* acregpackcheck                                          *
* net install sg162, from(http://www.stata.com/stb/stb60) *
***********************************************************


clear
set more off
version 16
cd "`c(pwd)'"


*************
* Load data *
*************

use roman_roads_1x1, clear

	
***********************
* Define control sets *
***********************

global geocoord      loglat loglon loglon2	                            
global waterways     logdist_coast logdist_major_river logdist_natharbour
global geo           logelev logoptcal_post1500
global geo_pre1500   logelev logoptcal_pre1500
global local         logdist_romanborder logmines logdist_capital
global local_pre1500 logdist_romanborder logmines 
global dist          logdist_coal logdist_univ logdist_witt  


***************************
* SPATIAL AUTOCORRELATION *
***************************

	reg logrr logpop2010 loglights20132020 logmodern logmajor_settlements if logrr>0, r
	keep if e(sample)
	sum lat lon 
	di sqrt((55.06-24.50)^2 + (39.32--9.21)^2) /* = 57.35 */
	spatwmat, name(W) eigenval(E) xcoord(lon) ycoord(lat) band(0 57) st
	
	* Figure A3
	spatcorr logrr, bands(0 5 10 15 20 25 30 35 40) x(lon) y(lat) gr cum two 
	graph export FigureA3.tif, replace

	* Figure A4
	spatcorr loglights20132020, bands(0 5 10 15 20 25 30 35 40) x(lon) y(lat) gr cum two 
	graph export FigureA4.tif, replace

	* Figure A5
	qui areg loglights20132020 logarea $geo $waterways $local $dist if RRdumab, r abs(clFE)
	qui predict loglights20132020e if e(sample), resid
	qui areg logrr logarea $geo $waterways $local $new if e(sample), r abs(clFE)
	qui predict logrre if e(sample), resid
	reg loglights20132020e logrre if e(sample), r
	predict resid if e(sample), resid 
	spatcorr resid, bands(0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20) x(lon) y(lat) gr cum two 
	graph export FigureA5.tif, replace
	spatdiag, w(W) 
	qui drop loglights20132020e logrre resid
