** Roman Roads to Prosperity: Persistence and Non-Persistence of Public Infrastructure
** Carl-Johan Dalgaard, Nicolai Kaarsen, Ola Olsson, Pablo Selaya
** Journal of Comparative Economics, 2022

** Robustness analysis (½ x ½ grid-cells)
** Appendix Tables A4, A5


***********************************************************
* Before running the do-file, make sure to install:       *
* ssc install acreg                                       *
* ssc install fsum                                        *
* ssc install bisncatter                                  *
* ssc install hdfe                                        *
* ssc install ranktest                                    *
* acregpackcheck                                          *
* net install sg162, from(http://www.stata.com/stb/stb60) *
***********************************************************



clear
set more off
version 16
cd "`c(pwd)'"


*************
* Load data *
*************

use roman_roads_½x½.dta, clear

	
***********************
* Define control sets *
***********************

global geocoord      loglat loglon loglon2	                            
global waterways     logdist_coast logdist_major_river logdist_natharbour
global geo           logelev logoptcal_post1500
global geo_pre1500   logelev logoptcal_pre1500
global local         logdist_romanborder logmines logdist_capital
global local_pre1500 logdist_romanborder logmines 
global dist          logdist_coal logdist_univ logdist_witt  


*********************************
* Table A4: ROBUSTNESS: ½ BY ½  *
*********************************

	areg logmajor_settlements logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab, abs(clFE) r
	est store A
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace
	areg logmodern logrr logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r
	est store B
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace
	areg loglights20132020 logrr logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r
	est store C	
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace
	areg logpop2010 logrr logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r
	est store D	
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace

	esttab A B C D using tableA4_½x½.tex, replace stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) booktabs  noconstant wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes title(Table A4: Robustness ½ by ½ Grid Cells) ///
	mgroups("Modern roads" "Settlements" "Lights"  "Pop. den.", pattern(1 1 1 1) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	postfoot(\bottomrule \multicolumn{5}{@{}p{0.65\linewidth}@{}} ///
	{\footnotesize Notes: Roman roads and modern roads are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and modern road system that lies wihin the total area of a country-cell. Roman settlements is log of one plus the number of major settlements within the country-cell in 500 CE. Nightlights is log of the average light intensity measured at night by satelite from 2013-2020 CE. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} )
	
	
************************************************
* Table A5: SAMPLE SPLIT AND ½ BY ½ GRID CELLS *
************************************************

	areg logmajor_settlements logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe==1, abs(clFE) r
	est store A
	estadd local fixedcl "Yes", replace
	areg logmajor_settlements logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe!=1, abs(clFE) r
	est store B	
	estadd local fixedcl "Yes", replace
	
	areg logmodern logrr logarea $geo $waterways $local $dist if RRdumab & Europe==1, abs(clFE) r
	est store C
	estadd local fixedcl "Yes", replace
	areg logmodern logrr logarea $geo $waterways $local $dist if RRdumab & Europe!=1, abs(clFE) r
	est store D
	estadd local fixedcl "Yes", replace
	
	areg loglights20132020  logrr logarea $geo $waterways $local $dist if RRdumab & Europe==1, abs(clFE) r
	est store E
	estadd local fixedcl "Yes", replace
	areg loglights20132020 logrr logarea $geo $waterways $local $dist if RRdumab & Europe!=1, abs(clFE) r
	est store F
	estadd local fixedcl "Yes", replace

	areg logpop2010 logrr logarea $geo $waterways $local $dist if RRdumab & Europe==1, abs(clFE) r
	est store G
	estadd local fixedcl "Yes", replace
	areg logpop2010 logrr logarea $geo $waterways $local $dist if RRdumab & Europe!=1, abs(clFE) r
	est store H
	estadd local fixedcl "Yes", replace
	
	esttab A B C D E F G H using tableA5_½x½split.tex, replace r2 booktabs noconstant stats(fixedcl N r2, label("Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) label b(3) se(3) nonotes nomtitles title(Table A5: Sample Split and ½ by ½ Grid Cells) ///
	mlabels("Europe" "MENA" "Europe" "MENA" "Europe" "MENA" "Europe" "MENA", lhs("Sample:")) mgroups("\shortstack{Settlements\\in 500 CE}" "Modern roads" "\shortstack{Nightlights\\from 2013-2020}" "\shortstack{Population\\in 2010}", pattern(1 0 1 0 1 0 1 0) lhs("Dependent variable:") prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	postfoot(\bottomrule \multicolumn{8}{@{}p{0.8\linewidth}@{}} ///
	{\footnotesize Notes: Roman roads and modern roads are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and modern road system that lies wihin the total area of a country-cell. Roman settlements is log of one plus the number of major settlements within the country-cell in 500 CE. Nightlights is log of the average light intensity measured at night by satelite from 2013-2020 CE. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} )
	

