** Roman Roads to Prosperity: Persistence and Non-Persistence of Public Infrastructure
** Carl-Johan Dalgaard, Nicolai Kaarsen, Ola Olsson, Pablo Selaya
** Journal of Comparative Economics, 2022

** Medieval markets analysis
** Table 7


***********************************************************
* Before running the do-file, make sure to install:       *
* ssc install acreg                                       *
* ssc install fsum                                        *
* ssc install bisncatter                                  *
* ssc install hdfe                                        *
* ssc install ranktest                                    *
* acregpackcheck                                          *
* net install sg162, from(http://www.stata.com/stb/stb60) *
***********************************************************



clear
set more off
version 16
cd "`c(pwd)'"


*************
* Load data *
*************

use roman_roads_table7.dta


***********************
* Define control sets *
***********************

global poly4 latitude longitude xy xsqy xysq latitude_sq longitude_sq latitude_cub longitude_cub
global dist8int dist_roman_border dist2 distint distint_2 dist3 distint_3 dist4 distint_4 dist5 distint_5 dist6 distint_6 dist7 distint_7 dist8 distint_8


**********************************************************
* Table 7: MEDIEVAL MARKETS AND ROMAN EMPIRE: OLS AND RD *
**********************************************************

	*Column 1 (RD on both sides of Roman border)
	reg markets_anytime roman $poly4, r
	est store A
	estadd local cpol "3rd", replace
	estadd local dpol "", replace
	estadd local segm "No", replace
	estadd local cont "No", replace

	*Column 2 (RD on both sides of Roman border)
	reg markets_anytime roman $dist8int, r
	est store B
	estadd local cpol "", replace
	estadd local dpol "8th", replace
	estadd local segm "No", replace
	estadd local cont "No", replace
		
	*Column 3 (RD on both sides of Roman border)
	reg markets_anytime roman $dist8int $poly4, r
	est store C
	estadd local cpol "3rd", replace
	estadd local dpol "8th", replace
	estadd local segm "No", replace
	estadd local cont "No", replace

	*Column 4 (RD on both sides of Roman border)
	areg markets_anytime roman $dist8int $poly4, abs(segments) r
	est store D
	estadd local cpol "3rd", replace
	estadd local dpol "8th", replace
	estadd local segm "Yes", replace
	estadd local cont "No", replace

	*Column 5 (RD on both sides of Roman border)
	areg markets_anytime roman $dist8int $poly4 suit ruggedness elevation1 dist_river, abs(segments) r
	est store E
	estadd local cpol "3rd", replace
	estadd local dpol "8th", replace
	estadd local segm "Yes", replace
	estadd local cont "Yes", replace

	*Column 6 (Roman road dummy, OLS only on Roman side of border)
	reg markets_anytime roman_road_pixel suit ruggedness elevation1 dist_river, r
	est store F
	estadd local cpol "", replace
	estadd local dpol "", replace
	estadd local segm "No", replace
	estadd local cont "Yes", replace

	*Column 7 (Distance to Roman road, OLS only on Roman side of border)
	reg markets_anytime lndist_roman_road suit ruggedness elevation1 dist_river, r
	est store G
	estadd local cpol "", replace
	estadd local dpol "", replace
	estadd local segm "No", replace
	estadd local cont "Yes", replace
	

	esttab A B C D E F G using table7_markets.tex, replace r2 booktabs noconstant ///
	stats(cpol dpol segm cont N r2, label("Order coord. polyn." "Order dist. polyn." "Segment dummies" "Controls" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) label b(3) se(3) nonotes nomtitles title(Table A7: Medieval markets and the Roman empire: RD and OLS regression) ///
	mgroups("Dependent variable: Medieval market dummy", pattern(1 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	mlabels("\shortstack{German \\ border area}" "\shortstack{German \\ border area}" "\shortstack{German \\ border area}" "\shortstack{German \\ border area}" "\shortstack{German \\ border area}" "\shortstack{Roman \\ part}" "\shortstack{Roman \\ part}", lhs("\shortstack{Region: \\ }")) ///
	postfoot(\bottomrule \multicolumn{8}{@{}p{0.8\linewidth}@{}} ///
	{\footnotesize Notes: This table documents the effect of the Roman Empire on market rights in the pre-modern period. The unit of analysis is 181,195 grid cells (size 0.86 km2) along the Roman limes from Wahl (2017) and the outcome variable is a dummy equal to 1 if there was a market town during the extended medieval period in the grid cell. The data on market towns was obtained from Cantoni and Yuchtman (2014). The right-hand side empirical specification is identical to that in Wahl (2017, Table 3, columns 2-6). Heteroskedasticity robust standard errors are reported in parentheses. *** denotes statistical significance at the 1 pct. level, ** at the 5 pct. level, and * at the 10 pct. level.} \\ \end{tabular} \end{table} ) keep(roman roman_road_pixel lndist_roman_road) 
