** Roman Roads to Prosperity: Persistence and Non-Persistence of Public Infrastructure
** Carl-Johan Dalgaard, Nicolai Kaarsen, Ola Olsson, Pablo Selaya
** Journal of Comparative Economics, 2022

** Main results (1 x 1 grid cells)
** Main Tables 1, 2, 3, 4, 5, 6
** Main Figures 1, 5, 6, 7
** Appendix Tables A1, A2, A3, A6, A7


***********************************************************
* Before running the do-file, make sure to install:       *
* ssc install acreg                                       *
* ssc install fsum                                        *
* ssc install bisncatter                                  *
* ssc install hdfe                                        *
* ssc install ranktest                                    *
* acregpackcheck                                          *
* net install sg162, from(http://www.stata.com/stb/stb60) *
***********************************************************



clear
set more off
version 16
cd "`c(pwd)'"


*************
* Load data *
*************

use roman_roads_1x1.dta, clear


***********************
* Define control sets *
***********************

global geocoord      loglat loglon loglon2	                            
global waterways     logdist_coast logdist_major_river logdist_natharbour
global geo           logelev logoptcal_post1500
global geo_pre1500   logelev logoptcal_pre1500
global local         logdist_romanborder logmines logdist_capital
global local_pre1500 logdist_romanborder logmines 
global dist          logdist_coal logdist_univ logdist_witt  


*****************************************
* Table 1: MODERN ROADS AND ROMAN ROADS *
*****************************************

	#delimit ;
	acreg logmodern logrr logarea $geocoord if RRdumab, latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	reg logmodern logrr aux_var logarea $geocoord if RRdumab, r; est store A; 
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "No", replace; estadd local fixedcl "No", replace;
	
	acreg logmodern logrr logarea if RRdumab, pfe1(cFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmodern logrr aux_var logarea if RRdumab, abs(cFE) r; est store B;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace;	estadd local fixedcl "No", replace;
	
	acreg logmodern logrr logarea $geo if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361);	local conley = _se[logrr];
	areg logmodern logrr aux_var logarea if RRdumab, abs(clFE) r; est store C;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logmodern logrr logarea $geo if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); 	local conley = _se[logrr];
	areg logmodern logrr aux_var logarea $geo if RRdumab, abs(clFE) r;	est store D;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logmodern logrr logarea $waterways if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmodern logrr aux_var logarea $waterways if RRdumab, abs(clFE) r; est store E;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;

	acreg logmodern logrr logarea $local $dist if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmodern logrr aux_var logarea $local $dist if RRdumab, abs(clFE) r;	est store F;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logmodern logrr logarea $geo $waterways $local $dist if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmodern logrr aux_var logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r;	est store G;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	esttab A B C D E F G using table1_modern.tex, replace stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) booktabs noconstant wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes collabels(none)
	mgroups("Dependent variable: Modern roads", pattern(1 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) title(Table 1: Roman Roads and Modern Roads) 
	cells( b(star fmt(3) drop(aux_var)) se(par drop(aux_var) fmt(3)) conley(par([ ]) keep(aux_var) fmt(3))) postfoot(\bottomrule \multicolumn{8}{@{}p{0.75\linewidth}@{}} 
	{\footnotesize Notes: Roman roads and modern roads are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and modern road system that lies wihin the total area of a countrycell. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} );
	

******************************
* Table 2: MAJOR SETTLEMENTS *
******************************

	#delimit;
	acreg logmajor_settlements logrr logarea $geocoord if RRdumab, latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	reg logmajor_settlements logrr aux_var logarea $geocoord if RRdumab, r;	est store A;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "No", replace;	estadd local fixedcl "No", replace;
	
	acreg logmajor_settlements logrr logarea if RRdumab, pfe1(cFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea if RRdumab, abs(cFE) r; est store B;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "No", replace;
	
	acreg logmajor_settlements logrr logarea if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea if RRdumab, abs(clFE) r;	est store C;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace;	estadd local fixedcl "Yes", replace;
	
	acreg logmajor_settlements logrr logarea $geo_pre1500 if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea $geo_pre1500 if RRdumab, abs(clFE) r; est store D;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logmajor_settlements logrr logarea $waterways if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea $waterways if RRdumab, abs(clFE) r;	est store E;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logmajor_settlements logrr logarea $local_pre1500 if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea $local_pre1500 if RRdumab, abs(clFE) r;	est store F;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logmajor_settlements logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab, abs(clFE) r;	est store G;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	esttab A B C D E F G using table2_settlements.tex, replace r2 booktabs noconstant stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes collabels(none) title(Table 2: Roman Roads and Settlements) 
	mgroups("Dependent variable: Roman Settlements in 500 CE", pattern(1 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) 	
	cells( b(star fmt(3) drop(aux_var)) se(par drop(aux_var) fmt(3)) conley(par([ ]) keep(aux_var) fmt(3))) postfoot(\bottomrule \multicolumn{8}{@{}p{0.75\linewidth}@{}} 
	{\footnotesize Notes: Roman roads is log of one plus the fraction of a 5 km buffer around the Roman road system that lies wihin the total area of a country-cell. Roman settlements is log of one plus the number of major settlements within the country-cell in CE 500. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} );

	
*******************
* Table 3: LIGHTS *
*******************
		
	#delimit ;
	acreg loglights20132020 logrr logarea $geocoord if RRdumab, latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	reg loglights20132020 logrr aux_var logarea $geocoord if RRdumab, r; est store A;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "No", replace;	estadd local fixedcl "No", replace;
	
	acreg loglights20132020 logrr logarea if RRdumab, pfe1(cFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea if RRdumab, abs(cFE) r; est store B;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace;	estadd local fixedcl "No", replace;
	
	acreg loglights20132020 logrr logarea if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea if RRdumab, abs(clFE) r; est store C;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg loglights20132020 logrr logarea $geo if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea $geo if RRdumab, abs(clFE) r; est store D;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg loglights20132020 logrr logarea $waterways if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea $waterways if RRdumab, abs(clFE) r; est store E;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg loglights20132020 logrr logarea $local $dist if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea $local $dist if RRdumab, abs(clFE) r; est store F;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg loglights20132020 logrr logarea $geo $waterways $local $dist if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r; est store G;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	esttab A B C D E F G using table3_lights.tex, replace r2 booktabs noconstant stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes collabels(none) title(Table 3: Roman Roads and Nightlights) ///
	mgroups("Dependent variable: Nightlights from 2013-2020", pattern(1 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	cells( b(star fmt(3) drop(aux_var)) se(par drop(aux_var) fmt(3)) conley(par([ ]) keep(aux_var) fmt(3))) postfoot(\bottomrule \multicolumn{8}{@{}p{0.75\linewidth}@{}} 
	{\footnotesize Notes: Roman roads is log of one plus the fraction of a 5 km buffer around the Roman road system that lies wihin the total area of a country-cell. Nightlights is log of the average light intensity measured at night by satelite from 2013-2020. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} );
	
	
*******************************
* Table 4: POPULATION DENSITY *
*******************************
	
	#delimit ;
	acreg logpop2010 logrr logarea $geocoord if RRdumab, latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	reg logpop2010 logrr aux_var logarea $geocoord if RRdumab, r; est store A;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "No", replace; estadd local fixedcl "No", replace;
	
	acreg logpop2010 logrr logarea if RRdumab, pfe1(cFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea if RRdumab, abs(cFE) r; est store B;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace;	estadd local fixedcl "No", replace;
	
	acreg logpop2010 logrr logarea if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea if RRdumab, abs(clFE) r; est store C;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logpop2010 logrr logarea $geo if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea $geo if RRdumab, abs(clFE) r;	est store D;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logpop2010 logrr logarea $waterways if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea $waterways if RRdumab, abs(clFE) r; est store E;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logpop2010 logrr logarea $local $dist if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea $local $dist if RRdumab, abs(clFE) r; est store F;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logpop2010 logrr logarea $geo $waterways $local $dist if RRdumab, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r; est store G;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace;
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	esttab A B C D E F G using table4_pop.tex, replace r2 booktabs noconstant stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes collabels(none) title(Table 4: Roman Roads and Population in 2010) ///
	mgroups("Dependent variable: Population in 2010", pattern(1 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	cells( b(star fmt(3) drop(aux_var)) se(par drop(aux_var) fmt(3)) conley(par([ ]) keep(aux_var) fmt(3))) postfoot(\bottomrule \multicolumn{8}{@{}p{0.75\linewidth}@{}} 
	{\footnotesize Notes: Roman roads is log of one plus the fraction of a 5 km buffer around the Roman road system that lies wihin the total area of a country-cell. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} );
	
	
*********************************************************************************************
* Table 5: SPLITTING THE SAMPLE - exploiting the abandonment of the wheel in the Arab world *
*********************************************************************************************

	#delimit ;
	acreg logmajor_settlements logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe==1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe==1, abs(clFE) r;	est store A;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	acreg logmajor_settlements logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe==!1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmajor_settlements logrr aux_var logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe!=1, abs(clFE) r; est store B;	
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	
	acreg logmodern logrr logarea $geo $waterways $local $dist if RRdumab & Europe==1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmodern logrr aux_var logarea $geo $waterways $local $dist if RRdumab & Europe==1, abs(clFE) r; est store C;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	acreg logmodern logrr logarea $geo $waterways $local $dist if RRdumab & Europe==!1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logmodern logrr aux_var logarea $geo $waterways $local $dist if RRdumab & Europe!=1, abs(clFE) r; est store D;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	
	acreg loglights20132020 logrr logarea $geo $waterways $local $dist if RRdumab & Europe==1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea $geo $waterways $local $dist if RRdumab & Europe==1, abs(clFE) r; est store E;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	acreg loglights20132020 logrr logarea $geo $waterways $local $dist if RRdumab & Europe==!1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg loglights20132020 logrr aux_var logarea $geo $waterways $local $dist if RRdumab & Europe!=1, abs(clFE) r; est store F;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;

	acreg logpop2010 logrr logarea $geo $waterways $local $dist if RRdumab & Europe==1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea $geo $waterways $local $dist if RRdumab & Europe==1, abs(clFE) r; est store G;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	acreg logpop2010 logrr logarea $geo $waterways $local $dist if RRdumab & Europe==!1, pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logpop2010 logrr aux_var logarea $geo $waterways $local $dist if RRdumab & Europe!=1, abs(clFE) r; est store H;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; estadd local fixedcl "Yes", replace;
	
	esttab A B C D E F G H using table5_split.tex, replace r2 title(Table 5: Sample Split: Roman Roads and Development in Europe and MENA) booktabs noconstant stats(fixedcl N r2, label("Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) label b(3) se(3) nonotes nomtitles collabels(none)
	mlabels("Europe" "MENA" "Europe" "MENA" "Europe" "MENA" "Europe" "MENA", lhs("Sample:")) mgroups("\shortstack{Settlements\\in 500 CE}" "Modern roads" "\shortstack{Nightlights\\from 2010-2013}" "\shortstack{Population\\in 2010}", pattern(1 0 1 0 1 0 1 0) lhs("Dependent variable:") prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span}))
	cells( b(star fmt(3) drop(aux_var)) se(par drop(aux_var) fmt(3)) conley(par([ ]) keep(aux_var) fmt(3))) postfoot(\bottomrule \multicolumn{8}{@{}p{0.8\linewidth}@{}} 
	{\footnotesize Notes: Roman roads and modern roads are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and modern road system that lies wihin the total area of a country-cell. Roman settlements is log of one plus the number of major settlements within the country-cell in 500 CE. Nightlights is log of the average light intensity measured at night by satelite from 2013-2020 CE. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} );

	
*********************************
* Table 6: CAMEL CARAVAN ROUTES *
*********************************

	#delimit ;
	acreg logcaravan logrr logarea $geocoord if RRdumab & (Africa | MEast), latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	reg logcaravan logrr aux_var logarea $geocoord if RRdumab & (Africa | MEast), r; est store A;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "No", replace;	estadd local fixedcl "No", replace;
	
	acreg logcaravan logrr logarea if RRdumab & (Africa | MEast), pfe1(cFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logcaravan logrr aux_var logarea if RRdumab & (Africa | MEast), abs(cFE) r; est store B;
	matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "Yes", replace;	estadd local fixedcl "No", replace;
	
	acreg logcaravan logrr logarea if RRdumab & (Africa | MEast), pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logcaravan logrr aux_var logarea if RRdumab & (Africa | MEast), abs(clFE) r; est store C;
  matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logcaravan logrr logarea $geo_pre1500 if RRdumab & (Africa | MEast), pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logcaravan logrr aux_var logarea $geo_pre1500 if RRdumab & (Africa | MEast), abs(clFE) r; est store D;
  matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logcaravan logrr logarea $waterways if RRdumab & (Africa | MEast), pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logcaravan logrr aux_var logarea $waterways if RRdumab & (Africa | MEast), abs(clFE) r; est store E;
  matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logcaravan logrr logarea $local_pre1500 if RRdumab & (Africa | MEast), pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logcaravan logrr aux_var logarea $local_pre1500 if RRdumab & (Africa | MEast), abs(clFE) r; est store F;
  matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	acreg logcaravan logrr logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & (Africa | MEast), pfe1(clFE) latitude(lat) longitude(lon) spatial dist(361); local conley = _se[logrr];
	areg logcaravan logrr aux_var logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & (Africa | MEast), abs(clFE) r; est store G;
  matrix X = e(b); matrix X[1,2] = `conley'; estadd matrix conley = X, replace; 
	estadd local fixedc "Yes", replace; estadd local fixedcl "Yes", replace;
	
	esttab A B C D E F G using table6_caravan.tex, replace stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) booktabs 	noconstant wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes title(Table 6: Caravan Routes and Roman Roads) collabels(none) 
	mgroups("Dependent variable: Camel caravan routes", pattern(1 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) 
	cells( b(star fmt(3) drop(aux_var)) se(par drop(aux_var) fmt(3)) conley(par([ ]) keep(aux_var) fmt(3))) postfoot(\bottomrule \multicolumn{8}{@{}p{0.75\linewidth}@{}} 
	{\footnotesize Notes: Roman roads and caravan routes are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and caravan route system that lies wihin the total area of a countrycell. The analysis is performed on country-cells within the Roman empire in the Middle East and North Africa containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} );
	
	#delimit cr

	
************************************
* Table A1: Descriptive statistics *
************************************

	areg logmajor_settlements logrr_c logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & logrr > 0, abs(clFE) r // Use to limit obs to those that are in sample
	preserve
	keep if e(sample)
	estpost tabstat logrr logmodern logmajor_settlements loglights20132020 logpop2010 $geo $waterways $local $dist if e(sample) < ., c(stat) stat(mean sd min max count)
	esttab using tableA1_descriptive.tex, nonumber nomtitle nonote noobs label booktabs collabels("Mean" "SD" Min Max N) cells("mean(fmt(%13.3fc)) sd(fmt(%13.3fc)) min(fmt(%13.3fc)) max(fmt(%13.3fc)) count(fmt(%13.0fc))") title(Table A1: Descriptive Statistics) replace
	restore


********************************
* Table A2: Correlation matrix *
********************************
 
	areg logmajor_settlements logrr_c logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & logrr_c > 0, abs(clFE) r // Use to limit obs to those that are in sample
	preserve
	keep if e(sample)
	estpost correlate $geo $waterways $local $dist if e(sample), matrix
	esttab using tableA2_correlation.tex, unstack not noobs label replace wrap varwidth(10) title(Table A2: Correlation matrix of control variables) gaps mtitle("[1]" "[2]" "[3]" "[4]" "[5]" "[6]" "[7]" "[8]" "[9]" "[10]" "[11]" eqlabels(none) )
	restore


*****************************************
* Table A3: DETERMINANTS OF ROMAN ROADS *
*****************************************

	reg logrr loglat loglon loglon2 logelev logoptcal_pre1500 if RRdumab>0, r
	est store A
	reg logrr Africa MEast if RRdumab>0, r
	est store B
	reg logrr logdist_coast logdist_major_river logdist_natharbour logdist_romanborder if RRdumab>0, r
	est store C
	reg logrr logmines if RRdumab>0, r
	est store D
	reg logrr logoppida if RRdumab>0, r
	est store E
	reg logrr loguncalc14bp if RRdumab>0, r
	est store F
	reg logrr $geocoord Africa MEast $waterways $geo_pre1500 $local_pre1500 if RRdumab>0, r
	est store G

	esttab A B C D E F G using tableA3_determinants.tex, replace r2 booktabs noconstant wrap varwidth(15) star(* 0.1 ** 0.05 *** 0.01) title(Table A3: Determinants of Roman Road intensity: Intensive margin) nomtitles label b(3) se(3) nonotes ///
	mgroups("Dependent variable: Roman roads", pattern(1 0 0 0 0 0 0 0 0 0) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) alignment(c) ///
	postfoot(\bottomrule \multicolumn{8}{@{}p{0.8\linewidth}@{}} ///
	{\footnotesize Notes: Roman roads are defined as the log of one plus the fraction of a 5 km buffer around the Roman road system that lies wihin the total area of a country-cell. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} )


********************************************
* Table A6: Robustness: Only certain roads *
********************************************	

	areg logmajor_settlements logrr_c logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & logrr_c > 0, abs(clFE) r
	est store A
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace
	areg logmodern logrr_c logarea $geo $waterways $local $dist if RRdumab & logrr_c > 0, abs(clFE) r
	est store B
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace
	areg loglights20132020 logrr_c logarea $geo $waterways $local $dist if RRdumab & logrr_c > 0, abs(clFE) r
	est store C	
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace
	areg logpop2010 logrr_c logarea $geo $waterways $local $dist if RRdumab & logrr_c > 0, abs(clFE) r
	est store D	
	estadd local fixedc "Yes", replace
	estadd local fixedcl "Yes", replace

	esttab A B C D using tableA6_certain.tex, replace stats(fixedc fixedcl N r2, label("Country FE" "Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.0f %9.3f)) booktabs noconstant wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) nomtitles label b(3) se(3) nonotes title(Table A6: Only certain roads) ///
	mgroups("Settlements" "Modern roads" "Lights" "Pop. den.", pattern(1 1 1 1) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	postfoot(\bottomrule \multicolumn{5}{@{}p{0.65\linewidth}@{}} ///
	{\footnotesize Notes: Roman roads and modern roads are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and modern road system that lies wihin the total area of a country-cell. Roman settlements is log of one plus the number of major settlements within the country-cell in 500 CE. Nightlights is log of the average light intensity measured at night by satelite from 2013-2020 CE. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} )


*************************************************************
* Table A7: Robustness: Only certain roads and sample split *
*************************************************************

	areg logmajor_settlements logrr_c logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe==1 & logrr_c > 0, abs(clFE) r
	est store A
	estadd local fixedcl "Yes", replace
	areg logmajor_settlements logrr_c logarea $geo_pre1500 $waterways $local_pre1500 if RRdumab & Europe!=1 & logrr_c > 0, abs(clFE) r
	est store B	
	estadd local fixedcl "Yes", replace

	areg logmodern logrr_c logarea $geo $waterways $local $dist if RRdumab & Europe==1 & logrr_c > 0, abs(clFE) r
	est store C
	estadd local fixedcl "Yes", replace
	areg logmodern logrr_c logarea $geo $waterways $local $dist if RRdumab & Europe!=1 & logrr_c > 0, abs(clFE) r
	est store D
	estadd local fixedcl "Yes", replace

	areg loglights20132020 logrr_c logarea $geo $waterways $local $dist if RRdumab & Europe==1 & logrr_c > 0, abs(clFE) r
	est store E
	estadd local fixedcl "Yes", replace
	areg loglights20132020 logrr_c logarea $geo $waterways $local $dist if RRdumab & Europe!=1 & logrr_c > 0, abs(clFE) r
	est store F
	estadd local fixedcl "Yes", replace

	areg logpop2010 logrr_c logarea $geo $waterways $local $dist if RRdumab & Europe==1 & logrr_c > 0, abs(clFE) r
	est store G
	estadd local fixedcl "Yes", replace
	areg logpop2010 logrr_c logarea $geo $waterways $local $dist if RRdumab & Europe!=1 & logrr_c > 0, abs(clFE) r
	est store H
	estadd local fixedcl "Yes", replace

	esttab A B C D E F G H using tableA7_certainsplit.tex, replace r2 title(Table A7. Only certain roads and Sample Split) booktabs noconstant stats(fixedcl N r2, label("Country-language FE" "Observations" "\(R^{2}\)") fmt(%9.0f %9.0f %9.3f)) wrap varwidth(20) star(* 0.1 ** 0.05 *** 0.01) label b(3) se(3) nonotes nomtitles collabels(none) ///
	mlabels("Europe" "MENA" "Europe" "MENA" "Europe" "MENA" "Europe" "MENA", lhs("Sample:")) mgroups("\shortstack{Settlements\\in 500 CE}" "Modern roads" "\shortstack{Nightlights\\in 2010}" "\shortstack{Population\\in 2010}", pattern(1 0 1 0 1 0 1 0) lhs("Dependent variable:") prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) ///
	postfoot(\bottomrule \multicolumn{8}{@{}p{0.8\linewidth}@{}} ///
	{\footnotesize Notes: Roman roads and modern roads are defined as the log of one plus the fraction of a 5 km buffer around, respectively, the Roman and modern road system that lies wihin the total area of a country-cell. Roman settlements is log of one plus the number of major settlements within the country-cell in 500 CE. Nightlights is log of the average light intensity measured at night by satelite from 2013-2020 CE. The analysis is performed on country-cells within the Roman empire containing non-zero Roman roads. Heteroskedasticity robust standard errors are reported in parentheses, Conley standard errors in square brackets. *** denotes statistical significance at the 1\% level, ** at the 5\% level, and * at the 10\% level.} \\ \end{tabular} \end{table} )


***********
* Figures *
***********

	graph set print logo off
	graph set window fontface "Times New Roman"

	* Figure 1: Population density 2010 & settlements in 500 CE

	areg logpop logmajor_settlements if RRdumab, abs(cFE) r
	qui xi: reg logpop i.cFE if e(sample)
	qui predict pplogpop if e(sample), resid
	qui xi: reg logmajor_settlements i.cFE if e(sample)
	qui predict plogmajor_settlements if e(sample), resid
	binscatter pplogpop plogmajor_settlements, reportreg msymbol(O) xtitle(Roman settlements in 500 CE (log)) ytitle(Population in 2010 (log))
	graph export Figure1.tif, replace
	drop pplogpop plogmajor_settlements


	* Figure 5: Modern roads and Roman roads (Table 1, col 7)

	areg logmodern logrr aux_var logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r
	xi: reg logmodern logrr logarea $geo $waterways $local $dist i.clFE if RRdumab, r
	qui xi: reg logmodern logarea $geo $waterways $local $dist i.clFE if e(sample)
	qui predict plogmodern_all_b5km if e(sample), resid
	qui xi: reg logrr logarea $geo $waterways $local $dist i.clFE if e(sample)
	qui predict plogrrab5km if e(sample), resid
	binscatter plogmodern_all_b5km plogrrab5km, reportreg msymbol(O) xtitle(Roman road density (log)) ytitle(Modern road density (log))
	graph export Figure5.tif, replace
	drop plogmodern_all_b5km plogrrab5km

	
	* Figure 6: Lights at night 2013-2020 & Roman roads (Table 3, col 7)

	areg loglights20132020 logrr aux_var logarea $geo $waterways $local $dist if RRdumab, abs(clFE) r
	xi: reg loglights20132020 logrr logarea $geo $waterways $local $dist i.clFE if RRdumab, r
	qui xi: reg loglights20132020 logarea $geo $waterways $local $dist i.clFE if e(sample)
	qui predict plogmodern_all_b5km if e(sample), resid
	qui xi: reg logrr logarea $geo $waterways $local $dist i.clFE if e(sample)
	qui predict plogrrab5km if e(sample), resid
	binscatter plogmodern_all_b5km plogrrab5km, reportreg msymbol(O) xtitle(Roman road density (log)) ytitle(Nightlights from 2013-2020 (log))
	graph export Figure6.tif, replace
	drop plogmodern_all_b5km plogrrab5km


	* Figure 7: Population 2010 & Roman roads (Table 4, col 7)

	xi: reg logpop2010 logrr logarea $geo $waterways $local $dist i.clFE if RRdumab, r
	qui xi: reg logpop2010 logarea $geo $waterways $local $dist i.clFE if e(sample)
	qui predict plogmodern_all_b5km if e(sample), resid
	qui xi: reg logrr logarea $geo $waterways $local $dist i.clFE if e(sample)
	qui predict plogrrab5km if e(sample), resid
	binscatter plogmodern_all_b5km plogrrab5km, reportreg msymbol(O) xtitle(Roman road density (log)) ytitle(Population size 2010 (log))
	graph export Figure7.tif, replace
	drop plogmodern_all_b5km plogrrab5km

