** BOUNTY OF THE SEA AND LONG-RUN DEVELOPMENT
** Anne Sofie B. Knudsen, Carl-Johan Dalgaard, and Pablo Selaya
** Journal of Economic Growth 2020
** Historical data

version 15
cls
clear
set more off

cd "`c(pwd)'"

**************************************
** Main text tables: Tables 1, 2, 3 **
**************************************


** Table 1

use data_02_ices_ihs, clear

gen logices_per3 = ln(ices_per3)
gen logihs_per3 = ln(ihs_per3) 
gen logeez_area = ln(eez_area)
gen logcatch_mfish50 = ln(1+catch_mfish50)
gen logcatch_mfish = ln(1+catch_mfish)

reg logices_per3 suit50_mfish logeez_area, r beta
reg logihs_per3 suit50_mfish logeez_area, r beta
reg logcatch_mfish50 suit50_mfish logeez_area africa asia oceania americas, r beta
reg logcatch_mfish50 suit50_mfish logeez_area if e(sample), r beta
reg logcatch_mfish suit50_mfish logeez_area if e(sample), r beta
reg logcatch_mfish50 suit50_mfish logeez_area africa asia oceania americas, r beta
reg logcatch_mfish suit50_mfish logeez_area africa asia oceania americas, r beta


** Table 2

use data_02_napp_hist, clear

gen logfishermen = ln(1+fishermen)
gen logpopulation = ln(population)
gen logb100_area = ln(b100_area)
gen logemployment = ln(1+employment)
gen logon_sea = ln(1+on_sea)
gen logboatmakers = ln(1+boatmakers)
xi i.year, noomit
label var logon_sea "(log) Ship workers"

reg logfishermen b100_suit50 logb100_area logemployment _Iyear_*, r beta
areg logfishermen b100_suit50 logb100_area logemployment _Iyear_*, r abs(countryname)
reg logboatmakers b100_suit50 logb100_area logemployment _Iyear_*, r beta
areg logboatmakers b100_suit50 logb100_area logemployment _Iyear_*, r abs(countryname)
reg logon_sea b100_suit50 logb100_area logemployment _Iyear_*, r beta
areg logon_sea b100_suit50 logb100_area logemployment _Iyear_*, r abs(countryname)


** Table 3

use data_02_ethno, clear

gen logoceanarea100 = ln(oceanarea100)
gen logdistance_coast = ln(1+distance_coast)

reg v205 suit50_100 logoceanarea100 logdistance_coast fensk_date, r beta
reg v206 suit50_100 logoceanarea100 logdistance_coast fensk_date, r beta
reg v207 suit50_100 logoceanarea100 logdistance_coast fensk_date, r beta
reg ea_V3 suit50_100 logoceanarea100 logdistance_coast fensk_date jan_region*, r beta
reg ea_V4 suit50_100 logoceanarea100 logdistance_coast fensk_date jan_region*, r beta
reg ea_V5 suit50_100 logoceanarea100 logdistance_coast fensk_date jan_region*, r beta

