% Version 0.1
% Embodied Technical Change Model from Groth (2010)
%
% The RELAXATION algorithm version 3.1 is used 
%
% Description of procedure:
% Trimborn, Koch, Steger (2007) Multidimensional Transitional Dynamics: A
% Simple Numerical Procedure, forthcoming in Macroeconomic Dynamics
 

clear all
disp(['Initialize Relaxation algorithm']);disp([' ']);

globalpar                           % Initializes the global parameter
parini                              % Loads the Parameter Values
relaxsetting                        % Loads the settings for the Relaxation algorithm, i.e. dimensions, boundary conditions etc. 

% Check the restrictions of the model

if lambda < ((1-alpha)/alpha) res1 = 1;
else res1 = 0; end
if (1-theta)*(((1-alpha)*gamma+alpha*lambda*nPop)/(1-alpha*(1+lambda))) < (rho-nPop)  res2 = 1;
else res2 = 0; end

if res1 == 0 || res2 == 0 disp('Restriction(s) not satisfied'); end

[guess, start, errorcode] = initrelax(@funcODE, @funcSTAT, n, n1, n3, nu, y, M, statev);       

if errorcode==0            % Executes the relaxation algorithm if no error occured during initilization

    [t, x]=relax(@funcODE, @funcSTAT, @funcINI, @funcfinal, n, n1, n3, nu, guess, M, start, Endcond, maxit, tol, damp, dampfac);    
    

    %Normalization of specified variables
    for i=1:M
        x(normal,i)=x(normal,i)./x(normal,end);
    end
    
    varex;                               % Extracts the variables and stores them in the memory

    [EVa EVe Jac]=eigDAS(@funcODE, @funcSTAT, x(:,end));
    disp(['Eigenvalues: ',num2str(EVa')]);

    
end















