% Plot of the results from the Ramsey Model With a Public Sector

% You may want to change the range on the axes. Suppose you want to 
% decrease the range on the vertical axis for the K/(A*L) plot from 0 7 to 0 5. Then 
% replace axis([0 100 -0 7]) by axis([0 100 -0 5]). If you want the range
% for, say K/(AL), to automatically adjust to the data, under "Resize the
% plot for k", replace axis([0 100 -0 7]) by axis([0 100 -inf inf]). If you want to change
% the number of periods on the horizontal axis for the C/(A*L) plot from 100 to 80, say, under 
% "Resize the plot for c" replace axis([0 100 -0 7]) by axis([0 80 -0 7]).

% Subplot(m,n,p) creates an mxn matrix of plots. p is an entry index

% Plot capital in the first subplot
myfig = subplot(2,1,1);

% Resize the plot for k
myax = get(myfig,'Position');
myax(3)=myax(3)-0.1;
set(myfig,'Position',myax);

hold on
plot(t,k,'b-');
hold on
plot(t,kss,'b-');
title('Growth-corrected capital: K/(AL)');
axis([0 100 0 10]);
xlabel('t');
ylabel('k');

% Plot consumption in the second subplot
myfig = subplot(2,1,2);

% Resize the plot for c
myax = get(myfig,'Position');
myax(3)=myax(3)-0.1;
set(myfig,'Position',myax);
hold on

plot(t,c,'b-');
hold on
plot(t,css,'b-');
title('Growth-corrected consumption: C/(AL)');
axis([0 100 0 3]);
xlabel('t');
ylabel('c');

% The 'average SOC' and the asymptotic SOC is calculated and added in a
% legend

% For k
if k(1) < kss
    a = find(k <= kss-abs(k(1)-kss)/2);
    b = size(a);
    halflife_k = (t(b(2))+t(b(2)+1))/2;
elseif k(1) == kss  
    halflife_k = 0;     % Cannot calculate halflife from the differential equation
elseif k(1) > kss
    a = find(k >= kss+abs(k(1)-kss)/2);
    b = size(a);
    halflife_k = (t(b(2))+t(b(2)+1))/2;
end

% For c
if c(1) < css
    a = find(c <= css-abs(c(1)-css)/2);
    b = size(a);
    halflife_c = (t(b(2))+t(b(2)+1))/2;
elseif c(1) == css  
    halflife_c = 0;     % Cannot calculate halflife from the differential equation
elseif c(1) > css
    a = find(c >= css+abs(c(1)-css)/2);
    b = size(a);
    halflife_c = (t(b(2))+t(b(2)+1))/2;
end

% Calculate the 'avergage SOC' from the half-life.
avSOC_k = -log(1/2)/halflife_k;
avSOC_c = -log(1/2)/halflife_c;

% The asymptotic SOC is given by the negative eigenvalue of the Jacobian Matrix
if EVa(1) > 0 j=2;
else j=1;
end
asympSOC = abs(EVa(j));

% The parameter values are added to the plot in a legend
sb = ['B = ', num2str(B)];
salpha = ['\alpha = ', num2str(alpha)];
sdelta = ['\delta = ', num2str(delta)];
srho = ['\rho = ', num2str(rho)];
snPop = ['n = ', num2str(nPop)];
sgA = ['g_{A} = ', num2str(gA)];
stheta = ['\theta = ', num2str(theta)];
sgamma = ['\gamma = ', num2str(gamma)];
staur = ['\tau = ', num2str(taur)];

% Plot the legend
annotation1 = annotation(...
  'textbox',...
  'Position',[0.8268 0.4888 0.1045 0.4393],...
    'LineStyle','none',...
  'String',{'Half-life k:',halflife_k,'Half-life c:',halflife_c,'Average SOC k:',avSOC_k,'Average SOC c;',avSOC_c,'Asymp. SOC c,k:',asympSOC,'','Parameters:',sb,salpha,sdelta,srho,snPop,sgA,stheta,sgamma,staur});

%'String',{'Parameters:',sb,salpha,sdelta,srho,snPop,sgA,stheta,sgamma,staur});


