/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/*********************************************************************************/
/* TABLE: Summary Statistics of Variables in the Individual-Level Trust Analyses */
/*********************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_stats_trust.log", text replace ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/trust_africa_rep.dta", clear ;
tabstat intra_group_trust odiv age male homelandpol district_ethnic_frac frac_ethnicity_in_district	school_present electricity_present piped_water_present sewage_present health_clinic_present urban_dum living_conditions education occupation religion exports, statistics(mean sd count p10 p90) columns(statistics) ;

use "../../data/trust_us_rep.dta", clear ;
tabstat trust pdiv_aa year age sex incom16 relig16 degree efrac des_pol15 abslat ruggavg elevavg suitavg suitrng distcr, statistics(mean sd count p10 p90) columns(statistics) ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
