/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/***********************************************************************************/
/* TABLE: Population Diversity and the Number of Conflicts across Ethnic Homelands */
/***********************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_freqy.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/obs_rep.dta", clear ;
xi: poisson cnum odiv ${regions} , r ;
xi: poisson cnum odiv ${regions} ${base} , r ;
xi: poisson cnum odiv ${regions} ${base} ${climate} ${endog} frac, r ;
xi: poisson cnum odiv ${regions} ${base} ${climate} ${endog} pol, r ;

use "../../data/pred_rep.dta", clear ;
xi: poisson cnum pdiv ${regions}, r ;
xi: poisson cnum pdiv ${regions} ${base}, r ;
xi: poisson cnum pdiv ${regions} ${base} ${climate} ${endog} frac, r ;
xi: poisson cnum pdiv ${regions} ${base} ${climate} ${endog} pol, r ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
