/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/**********************************************************************************************************************************************************/
/* TABLE: Predicted Population Diversity and Conflict across Ethnic Homelands – Robustness to Accounting for Predicted Diversity as a Generated Regressor */
/**********************************************************************************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_boots.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/pred_rep.dta", clear ;

egen hid2_num = group(hid2) ;

xi: reg lcsnm pdiv ${regions}, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate}, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate} ${endog} frac, r ;
xi: reg lcsnm pdiv ${regions} ${base} ${climate} ${endog} pol, r ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
