/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/*********************************************************************************************************************************************/
/* TABLE: Observed Population Diversity and Conflict across Ethnic Homelands – Robustness to Accounting for Measures of Ecological Diversity */
/*********************************************************************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/stab_eco_odiv.log", text replace ;

/*****************/
/* Load the data */
/*****************/

use "../../data/obs_rep.dta", clear ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;

/***********************/
/* Run the regressions */
/***********************/

xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions}, r ;
xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions} ${base}, r ;
xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions} ${base} ${climate}, r ;
xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions} ${base} ${climate} frac, r ;
xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions} ${base} ${climate} pol, r ;
xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions} ${base} ${climate} ${endog} frac, r ;
xi: reg lcsnm odiv ecodiv_div ecodiv_pol ${regions} ${base} ${climate} ${endog} pol, r ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
