/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/*********************************************************************************************************************/
/* TABLE: Country-of-Origin Population Diversity and Individual-Level Trust among Second- Generation U.S. Immigrants */
/*********************************************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/mtab_trust_us.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/trust_us_rep.dta", clear ;
ivreg2 trust pdiv_aa africa asia americas oceania wb_lac, cluster(homeland_iso3 region) ;
ivreg2 trust pdiv_aa africa asia americas oceania wb_lac i.year, cluster(homeland_iso3 region) ;
ivreg2 trust pdiv_aa africa asia americas oceania wb_lac i.year i.age i.sex i.incom16 i.relig16 i.degree i.region efrac, cluster(homeland_iso3 region) ;
ivreg2 trust pdiv_aa africa asia americas oceania wb_lac i.year i.age i.sex i.incom16 i.relig16 i.degree i.region des_pol15, cluster(homeland_iso3 region) ;
ivreg2 trust pdiv_aa africa asia americas oceania wb_lac i.year i.age i.sex i.incom16 i.relig16 i.degree i.region efrac i.region abslat ruggavg elevavg suitavg suitrng distcr, cluster(homeland_iso3 region) ;
ivreg2 trust pdiv_aa africa asia americas oceania wb_lac i.year i.age i.sex i.incom16 i.relig16 i.degree i.region des_pol15 i.region abslat ruggavg elevavg suitavg suitrng distcr, cluster(homeland_iso3 region) ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
