/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/******************************************************************************/
/* FIGURE: Observed Population Diversity and Conflict across Ethnic Homelands */
/******************************************************************************/

# delimit ;
clear all ;

set more off ;

/**************************/
/* Specify a color scheme */
/**************************/

global RGBcolor1 "215 48 39" ;
global RGBcolor2 "252 141 89" ;
global RGBcolor3 "254 224 144" ;
global RGBcolor4 "224 243 248" ;
global RGBcolor5 "145 191 219" ;
global RGBcolor6 "69 117 180" ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/mfig_odiv.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;

/*****************/
/* Load the data */
/*****************/

use "../../data/obs_rep.dta", clear ;

/***********************/
/* Generate the figure */
/***********************/

xi: regress       lcsnm   ${regions} ${base} ${climate}, vce(robust) ;
predict resids1, resid ;

xi: regress       odiv    ${regions} ${base} ${climate}, vce(robust) ;
predict resids2, resid ;

xi: regress resids1 resids2, vce(robust) ;

local coef = string(_b[resids2], "%8.3f") ;
local serr = string(_se[resids2], "%8.3f") ;
local tsta = string(_b[resids2] / _se[resids2], "%8.3f") ;
local ptr2 = string(`e(r2)', "%8.3f") ;
local nobs = string(`e(N)', "%8.0g") ;

twoway (scatter resids1 resids2 if cont == 1 , msymbol(o) msize(medium) mfcolor("$RGBcolor1") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
       (scatter resids1 resids2 if cont == 2 , msymbol(o) msize(medium) mfcolor("$RGBcolor2") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
       (scatter resids1 resids2 if cont == 3 , msymbol(o) msize(medium) mfcolor("$RGBcolor3") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
       (scatter resids1 resids2 if cont == 4 , msymbol(o) msize(medium) mfcolor("$RGBcolor4") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
       (scatter resids1 resids2 if cont == 5 , msymbol(o) msize(medium) mfcolor("$RGBcolor5") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
       (scatter resids1 resids2 if cont == 6 , msymbol(o) msize(medium) mfcolor("$RGBcolor6") mlcolor(black) mlwidth(vthin) mlabpos(6) mlabsize(1.25) mlabcolor(gs11)) ||
       (lfit    resids1 resids2, clcolor(black) lstyle(refline) xlabel(-0.075(0.025)0.05)),
            ylabel(, labsize(vsmall) glcolor(gs14) glwidth(medthin) nogrid)
            xlabel(, labsize(vsmall))
            ytitle("")
            xtitle("")
            title("", size(small))
            subtitle("" " ", size(vsmall))
            l1title("(Residuals)" " ", size(vsmall))
            l2title("Log conflict prevalence", size(small))
            b1title(" " "(Residuals)", size(vsmall))
            b2title("Genetic diversity (observed)", size(small))
            note(" " "Relationship in the global sample; baseline geographical and climatic controls as well as regional dummies", span size(vsmall))
            caption("Slope coefficient = `coef'; (robust) standard error = `serr'; t-statistic = `tsta'; partial R-squared = `ptr2'; observations = `nobs'", span size(vsmall))
            legend(order(1 2 3 4 5 6) rows(1) label(1 "Africa") label(2 "Europe") label(3 "Asia") label(4 "Oceania") label(5 "N. America") label(6 "S. America") size(vsmall) position(6) region(style(none)))
            graphregion(color(white)) plotregion(color(white)) bgcolor(white) ;

graph export "../../results/figures/mfig_odiv.pdf", as(pdf) replace ;

/*******************************/
/* Close the log file and exit */
/*******************************/

log close ;

exit ;
