* logit2dclust.ado -- modified version of logit2.ado by Jingling Guan/Mitchell Petersen, February 2008
* Program calculates clustered standard errors in both a firm and time dimension for logit models
*  as described by Thompson in "A Simple Formula for Standard Errors that Cluster by Both Firm and Time" and
*      	and Cameron, Gelbach, and Miller, 2006, "Robust Inference with Multi-way Clustering"
*  Additions and edits
*   Corrected ereturn list to be consistent with standard logit estimation -- July 2017 (Quamrul Ashraf) 
*  	Compliant with outreg 
*	Checks for multiple observations per fcluster-tcluster

#delimit ;
program define logit2dclust, eclass sortpreserve byable(recall);
	syntax [varlist] [in] [if], fcluster(varname) tcluster(varname);
	tokenize `varlist';
	marksample touse;
	local depv `"`1'"';
* ---------------------------------------------------------------- ;
* ------- Logit Clustering by First Variable (e.g. Firm) --------- ;
* ---------------------------------------------------------------- ;
	quietly logit `varlist' if `touse', robust cluster(`fcluster');
	matrix vcf = e(V);
	local nfcluster=e(N_clust);
* ---------------------------------------------------------------- ;
* -------- Logit Clustering by Second Variable (e.g. Time) ------- ;
* ---------------------------------------------------------------- ;
	quietly logit `varlist' if `touse', robust cluster(`tcluster');
	matrix vct = e(V);
	local ntcluster=e(N_clust);
* ---------------------------------------------------------------- ;
* ------------------  Logit with "No Clustering"  ---------------- ;
* ---------------------------------------------------------------- ;
	capture confirm string variable `fcluster';
	if !_rc {;
		gen bc1 = `fcluster'; /* string variable */
		};
		else {;
		gen bc1 = string(`fcluster'); /* numeric */
		};
	capture confirm string variable `tcluster';
	if !_rc {;
		gen bc2 = `tcluster'; /* string variable */
		};
		else {;
		gen bc2 = string(`tcluster'); /* numeric */
		};
	gen bc3 = bc1 + "_" + bc2;
	* --------------------------------------------------------- ;
	*   Check for multiple observations per fcluster-tcluster   ;
	* --------------------------------------------------------- ;
	bysort bc3: gen unique_obs = _n==1;	* =1 if only one obs per fcluster-tcluster;
	qui sum unique_obs;		

	if r(mean)==1 {;
	   	quietly logit `varlist' if `touse', robust;
	   	local mcluster=0;
		};
	   else {;
	   	quietly logit `varlist' if `touse', robust cluster(bc3);
	   	local mcluster =1 ;
		};
	drop bc1 bc2 bc3 unique_obs;

	local nparm = e(df_m)+1;
	matrix coef = e(b);
	matrix vc = vcf+vct-e(V);
	
* ---------------------------------------------------------------- ;
* ------------------- Print out Logit Results -------------------- ;
* ---------------------------------------------------------------- ;
	tokenize `varlist';  	/* this puts varlist in to the macros `1' `2' etc */
	macro shift;			/* drops first arguement (dep var) and shifts the rest up one */

	dis " ";
	dis in green "Logistic regression (2D clustered SEs)"											in green _column(55) "Number of obs"				_column(72) "=" %10.0f in yellow e(N);
	dis in green "Number of clusters (`fcluster')"	_column(30) "= " %10.0f in yellow $_nfcluster	in green _column(55) "Wald chi2(" %2.0f e(df_m) ")"	_column(72) "=" %10.2f in yellow e(chi2);
	dis in green "Number of clusters (`tcluster')"	_column(30) "= " %10.0f in yellow $_ntcluster	in green _column(55) "Prob > chi2"					_column(72) "=" %10.4f in yellow chi2tail(e(df_m),e(chi2));
   	dis in green "Log pseudolikelihood"				_column(30) "= " %10.5f in yellow e(ll)			in green _column(55) "Pseudo R2"					_column(72) "=" %10.4f in yellow e(r2_p);
	dis " ";

* ---------------------------------------------------------------- ;
* -------------------- upload Logit Results into e()-------------- ;
* ---------------------------------------------------------------- ;

* save statistics from the last logit (clustered by fcluster+tcluster);
* scalars;
	scalar e_N = e(N);
	scalar e_N_cds = e(N_cds);
	scalar e_N_cdf = e(N_cdf);
	scalar e_k = e(k);
	scalar e_k_eq = e(k_eq);
	scalar e_k_eq_model = e(k_eq_model);
	scalar e_k_dv = e(k_dv);
	scalar e_df_m = e(df_m);
	scalar e_r2_p = e(r2_p);
	scalar e_ll = e(ll);
	scalar e_ll_0 = e(ll_0);
	scalar e_N_fclust = $_nfcluster;
	scalar e_N_tclust = $_ntcluster;
	scalar e_chi2 = e(chi2);
	scalar e_p = e(p);
	scalar e_ic = e(ic);
	scalar e_rc = e(rc);
	scalar e_converged = e(converged);

* prepare matrices to upload into e();
	ereturn clear;
	tempname b V;
	matrix `b' = coef;
	matrix `V' = vc;

* post the resuls in e();
	ereturn post `b' `V', esample(`touse');

	ereturn scalar N = e_N;
	ereturn scalar N_cds = e_N_cds;
	ereturn scalar N_cdf = e_N_cdf;
	ereturn scalar k = e_k;
	ereturn scalar k_eq = e_k_eq;
	ereturn scalar k_eq_model = e_k_eq_model;
	ereturn scalar k_dv = e_k_dv;
	ereturn scalar df_m = e_df_m;
	ereturn scalar r2_p = e_r2_p;
	ereturn scalar ll = e_ll;
	ereturn scalar ll_0 = e_ll_0;
	ereturn scalar N_fclust = e_N_fclust;
	ereturn scalar N_tclust = e_N_tclust;
	ereturn scalar chi2 = e_chi2;
	ereturn scalar p = e_p;
	ereturn scalar ic = e_ic;
	ereturn scalar rc = e_rc;
	ereturn scalar converged = e_converged;

	ereturn local cmd "logit2dclus";
	ereturn local depvar "`depv'";
	ereturn local title "Logistic regression (2D clustered SEs)";
	ereturn local clustvar1 "`fcluster'";
	ereturn local clustvar2 "`tcluster'";
	ereturn local vce "2D clustered";
	ereturn local vcetype "2D Clust.";
* end of uploading;
* ==================================================================;

* display coefficients and se;
	ereturn display;
	dis " ";
	if $_mcluster==1 {;
		dis "     SE clustered by " "`fcluster'" " and " "`tcluster'" " (multiple obs per " "`fcluster'" "-" "`tcluster'" ")";
		};
	   else {;
		dis "     SE clustered by " "`fcluster'" " and " "`tcluster'";
		};		
	dis " "; 

	scalar drop e_N e_N_cds e_N_cdf e_k e_k_eq e_k_eq_model e_k_dv e_df_m e_r2_p e_ll e_ll_0 e_N_fclust e_N_tclust e_chi2 e_p e_ic e_rc e_converged;
	matrix drop coef vc vcf vct;

end;
