/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/*****************************************************************************************/
/* TABLE: Population Diversity and Alternative Conflict Outcomes across Ethnic Homelands */
/*****************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/xtab_alt.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;
global frac "frac pol" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/obs_rep.dta", clear ;
xi: reg lcnum odiv ${regions} ${base} ${climate} ${frac}, r ;

use "../../data/pred_rep.dta", clear ;
xi: reg lcnum pdiv ${regions} ${base} ${climate} ${frac}, r ;

use "../../data/obs_rep.dta", clear ;
xi: reg lcdeaths odiv ${regions} ${base} ${climate} ${frac}, r ;

use "../../data/pred_rep.dta", clear ;
xi: reg lcdeaths pdiv ${regions} ${base} ${climate} ${frac}, r ;

use "../../data/obs_rep.dta", clear ;
xi: eststo r5a: reg lratio odiv ${regions} ${base} ${climate} ${frac}, r ;

use "../../data/pred_rep.dta", clear ;
xi: reg lratio pdiv ${regions} ${base} ${climate} ${frac}, r ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
