/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/*************************************************************************************************************************/
/* TABLE: Population Diversity and Conflict across Ethnic Homelands – Robustness to Accounting for Alternative Distances */
/*************************************************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/stab_adist.log", text replace ;

/********************************************************/
/* Create global macro lists of the relevant covariates */
/********************************************************/

global regions "i.cont ssa" ;
global base "abslat rugg elev elev_range postcal postcal_range island distwater" ;
global climate "tmp pre" ;
global endog "yss malaria petro_dummy llm" ;
global frac "frac pol" ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/obs_rep.dta", clear ;
xi: reg lcsnm odiv distance_frontier_1 ${regions} ${base} ${climate} ${frac}, r ;
xi: reg lcsnm odiv distance_frontier_1000 ${regions} ${base} ${climate} ${frac}, r ;
xi: reg lcsnm odiv distance_frontier_1500 ${regions} ${base} ${climate} ${frac}, r ;

use "../../data/pred_rep.dta", clear ;
xi: reg lcsnm pdiv distance_frontier_1 ${regions} ${base} ${climate} ${frac}, r ;
xi: reg lcsnm pdiv distance_frontier_1000 ${regions} ${base} ${climate} ${frac}, r ;
xi: reg lcsnm pdiv distance_frontier_1500 ${regions} ${base} ${climate} ${frac}, r ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
