/******************************************************************************/
/*** DESCRIPTION:  REPLICATION CODE FOR "DIVERSITY AND CONFLICT"            ***/
/*** AUTHORS:      EREN ARBATLI, QUAMRUL ASHRAF, ODED GALOR, AND MARC KLEMP ***/
/******************************************************************************/

/************************************************************************************/
/* TABLE: Ethnic-Homeland Population Diversity and Individual-Level Trust in Africa */
/************************************************************************************/

# delimit ;
clear all ;

set more off ;

/*******************/
/* Open a log file */
/*******************/

capture log close ;
log using "../../results/logs/mtab_trust_africa.log", text replace ;

/*****************************************/
/* Load the data and run the regressions */
/*****************************************/

use "../../data/trust_africa_rep.dta", clear ;
ivreg2 intra_group_trust odiv i.host_iso3, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male homelandfrac, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male homelandpol, cluster(host_iso3 nameinatlas) ; ;
ivreg2 intra_group_trust odiv i.host_iso3 age male district_ethnic_frac, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male frac_ethnicity_in_district, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male homelandfrac district_ethnic_frac frac_ethnicity_in_district, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male homelandpol district_ethnic_frac frac_ethnicity_in_district, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male homelandfrac district_ethnic_frac frac_ethnicity_in_district school_present electricity_present piped_water_present sewage_present health_clinic_present urban_dum i.living_conditions i.education i.occupation i.religion exports i.homeland_iso3, cluster(host_iso3 nameinatlas) ;
ivreg2 intra_group_trust odiv i.host_iso3 age male homelandpol district_ethnic_frac frac_ethnicity_in_district school_present electricity_present piped_water_present sewage_present health_clinic_present urban_dum i.living_conditions i.education i.occupation i.religion exports i.homeland_iso3, cluster(host_iso3 nameinatlas) ;

/***********************************************************/
/* Clean-up stored estimates, close the log file, and exit */
/***********************************************************/

est clear ;
log close ;

exit ;
