use wvs_data, clear

egen id=group(iso_cc first)
bys id year: gen sum=_N

bys iso_cc: egen sumwc=sum(s017)
gen s017wc=s017/sumwc

/*OLS*/

cd "Z:\Seasons\Stata_output_okocrunchit"
quietly: xi: areg demo_good irri_impact age male agr_worker i.tot_inc i.tot_edu i.year if sum>10 [pw=s017wc], cl(id) absorb(iso_cc)
local clus =e(N_clust)
quietly: tab iso_cc if e(sample)
local rr =r(r)
outreg2 irri_impact using wvs, replace title(Table X) addtext(Country FE, Y, Individual controls, Y, Geo controls, N) addstat(Countries, `rr', Regions, `clus') bdec(3) dec(3) nonot label nocons
quietly: xi: areg demo_good irri_impact age male agr_worker i.tot_inc i.tot_edu i.year lat_jb prec6190 temp soil12 if sum>10 [pw=s017wc], cl(id) absorb(iso_cc)
local clus =e(N_clust)
quietly: tab iso_cc if e(sample)
local rr =r(r)
outreg2 irri_impact using wvs, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) addstat(Countries, `rr', Regions, `clus') bdec(3) dec(3) nonot label nocons
quietly: xi: areg demo_good irri_impact age male agr_worker i.tot_inc i.tot_edu i.year Islam lat_jb prec6190 temp soil12 if sum>10 [pw=s017wc], cl(id) absorb(iso_cc)
local clus =e(N_clust)
quietly: tab iso_cc if e(sample)
local rr =r(r)
outreg2 irri_impact using wvs, append addtext(Country FE, Y, Individual controls, Y, Geo controls, N) addstat(Countries, `rr', Regions, `clus') bdec(3) dec(3) nonot label nocons
quietly: xi: areg demo_better irri_impact age male agr_worker i.tot_inc i.tot_edu i.year if sum>10 [pw=s017wc], cl(id) absorb(iso_cc)
local clus =e(N_clust)
quietly: tab iso_cc if e(sample)
local rr =r(r)
outreg2 irri_impact using wvs, append addtext(Country FE, Y, Individual controls, Y, Geo controls, N) addstat(Countries, `rr', Regions, `clus') bdec(3) dec(3) nonot label nocons
quietly: xi: areg demo_better irri_impact age male agr_worker i.tot_inc i.tot_edu i.year lat_jb prec6190 temp soil12 if sum>10 [pw=s017wc], cl(id) absorb(iso_cc)
local clus =e(N_clust)
quietly: tab iso_cc if e(sample)
local rr =r(r)
outreg2 irri_impact using wvs, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) addstat(Countries, `rr', Regions, `clus') bdec(3) dec(3) nonot label nocons
quietly: xi: areg demo_better irri_impact age male agr_worker i.tot_inc i.tot_edu i.year lat_jb prec6190 temp soil12 Islam if sum>10 [pw=s017wc], cl(id) absorb(iso_cc)
local clus =e(N_clust)
quietly: tab iso_cc if e(sample)
local rr =r(r)
outreg2 irri_impact using wvs, append addtext(Country FE, Y, Individual controls, Y, Geo controls, N) addstat(Countries, `rr', Regions, `clus') bdec(3) dec(3) nonot label nocons tex(frag)

/*IV*/

/*Second stage*/

quietly: xi: ivreg2 demo_good (irri_current_arable=irri_impact) age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc i.year if sum>10 [pw=s017wc], cl(id) ffirst
outreg2 irri_current_arable using wvs_iv, replace addtext(Country FE, Y, Individual controls, Y, Geo controls, N) addstat(Kleibergen-Paap F, e(widstat), A Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons
quietly: xi: ivreg2 demo_good (irri_current_arable=irri_impact) age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc lat_jb prec6190 temp soil12 i.year if sum>10 [pw=s017wc], cl(id) ffirst
outreg2 irri_current_arable using wvs_iv, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) addstat(Kleibergen-Paap F, e(widstat), A Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons
quietly: xi: ivreg2 demo_good (irri_current_arable=irri_impact) age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc Islam lat_jb prec6190 temp soil12 i.year if sum>10 [pw=s017wc], cl(id) ffirst
outreg2 irri_current_arable Islam using wvs_iv, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) addstat(Kleibergen-Paap F, e(widstat), A Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons

quietly: xi: ivreg2 demo_better (irri_current_arable=irri_impact) age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc i.year if sum>10 [pw=s017wc], cl(id) ffirst
outreg2 irri_current_arable using wvs_iv, append addtext(Country FE, Y, Individual controls, Y, Geo controls, N) addstat(Kleibergen-Paap F, e(widstat), A Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons
quietly: xi: ivreg2 demo_better (irri_current_arable=irri_impact) age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc lat_jb prec6190 temp soil12 i.year if sum>10 [pw=s017wc], cl(id) ffirst
outreg2 irri_current_arable using wvs_iv, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) addstat(Kleibergen-Paap F, e(widstat), A Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons
quietly: xi: ivreg2 demo_better (irri_current_arable=irri_impact) age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc Islam lat_jb prec6190 temp soil12 i.year if sum>10 [pw=s017wc], cl(id) ffirst
outreg2 irri_current_arable Islam using wvs_iv, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) addstat(Kleibergen-Paap F, e(widstat), A Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons tex(frag)

/*First stage*/

quietly: xi: reg irri_current_arable irri_impact age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc i.year [pw=s017wc] if demo_good!=., cl(id)
outreg2 irri_impact using wvs_iv1, replace title(First stage) addtext(Country FE, Y, Individual controls, Y, Geo controls, N) bdec(3) dec(3) nonot label nocons
quietly: xi: reg irri_current_arable irri_impact age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc lat_jb prec6190 temp soil12 i.year [pw=s017wc] if demo_good!=., cl(id)
outreg2 irri_impact using wvs_iv1, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) bdec(3) dec(3) nonot label nocons
quietly: xi: reg irri_current_arable irri_impact age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc Islam lat_jb prec6190 temp soil12 i.year [pw=s017wc] if demo_good!=., cl(id)
outreg2 irri_impact Islam using wvs_iv1, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) bdec(3) dec(3) nonot label nocons

quietly: xi: reg irri_current_arable irri_impact age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc i.year [pw=s017wc] if demo_better!=., cl(id)
outreg2 irri_impact using wvs_iv1, append addtext(Country FE, Y, Individual controls, Y, Geo controls, N) bdec(3) dec(3) nonot label nocons
quietly: xi: reg irri_current_arable irri_impact age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc lat_jb prec6190 temp soil12 i.year [pw=s017wc] if demo_better!=., cl(id)
outreg2 irri_impact using wvs_iv1, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) bdec(3) dec(3) nonot label nocons
quietly: xi: reg irri_current_arable irri_impact age male agr_worker i.tot_inc i.tot_edu i.year i.iso_cc Islam lat_jb prec6190 temp soil12 i.year [pw=s017wc] if demo_better!=., cl(id)
outreg2 irri_impact Islam using wvs_iv1, append addtext(Country FE, Y, Individual controls, Y, Geo controls, Y) bdec(3) dec(3) nonot label nocons tex(frag)


