cd "C:\Users\okojb\Dropbox\Irrigation\EEA submission\Data"

use country_data, clear

/* Table 2. Actual irrigation and irrigation potential */

local geo abslat_jb precavr tempavr soil12

reg irri_actcult irri_impact5 `geo', r
reg irri_actcult irri_impact4_5 `geo', r
reg irri_actcult irri_impact3_5 `geo', r
reg irri_actcult irri_impact2_5 `geo', r

/* Table 3. Different polity measures */

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"
rename polity2 polity2_org

gen polity2=polity2010
reg polity2 irri_impact5, r
outreg2 using irri_spec, title(Table 2. Various measures of democracy on irrigation potential) addtext(Period, 2010) label replace bdec(3) nocons drop(con_*) nonot
replace polity2=polity2_org
reg polity2 irri_impact5, r
outreg2 using irri_spec, append label addtext(Period, 1991-2010) bdec(3) nocons drop(con_*) nonot
replace polity2=polity2_1950
reg polity2 irri_impact5, r
outreg2 using irri_spec, append label addtext(Period, 1950-2010) bdec(3) nocons drop(con_*) nonot
replace polity2=polity21800_2010
reg polity2 irri_impact5, r
outreg2 using irri_spec, append label addtext(Period, 1800-2010) bdec(3) nocons drop(con_*) nonot
replace polity2=polity2_before1950
reg polity2 irri_impact5, r
outreg2 using irri_spec, append label addtext(Period, 1800-1950) bdec(3) nocons drop(con_*) nonot
replace polity2=polity2_org
drop polity2_org
reg fh_avg irri_impact5, r
outreg2 using irri_spec, append label addtext(Period, 1991-2010) bdec(3) nocons drop(con_*) nonot tex(frag)

/* Table 4. Main results */

reg polity2 irri_impact5 con_* abslat_jb precavr tempavr soil12 oilpop2000 river100, r
gen sample=e(sample)

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"
reg polity2 irri_impact5  con_*	if sample==1, r
outreg2 using irri_mainreg, label replace title(Table 3. Democracy on irrigation potential controlling for geography) drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) bdec(3) dec(3) nocons nonot
reg polity2 irri_impact5 con_* abslat_jb precavr tempavr soil12	if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 con_* precavr precavr_sq if e(sample), r
test precavr=precavr_sq=0
outreg2 using irri_mainreg, label drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* precavr precavr_sq	if sample==1, r
test precavr=precavr_sq=0
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* oilpop2000 if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* river100	if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* abslat_jb river100 precavr tempavr soil12 oilpop2000 if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
qreg polity2 irri_impact5 con_* abslat_jb river100 precavr tempavr soil12 oilpop2000 if sample==1
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, Median, Continent dummies, Yes) nocons bdec(3) dec(3) nonot tex(frag)

/* Conley se for Table 4 */

gen constant=1
gen conley_cutoff1=500000
gen conley_cutoff2=500000

gen nomis=0
replace nomis=1  if sample==1

preserve
drop if nomis==0
x_ols2 Lat_meter Lon_meter conley_cutoff1 conley_cutoff2 polity2 irri_impact5 con_1 con_2 con_3 con_4 con_5 constant, xreg(7) coord(2)
restore

preserve
drop if nomis==0
x_ols2 Lat_meter Lon_meter conley_cutoff1 conley_cutoff2 polity2 irri_impact5 con_1 con_2 con_3 con_4 con_5 arable abslat_jb precavr tempavr soil12 constant, xreg(12) coord(2)
restore

preserve
drop if nomis==0
x_ols2 Lat_meter Lon_meter conley_cutoff1 conley_cutoff2 polity2 irri_impact5 con_1 con_2 con_3 con_4 con_5 precavr precavr_sq constant, xreg(9) coord(2)
restore

preserve
drop if nomis==0
x_ols2 Lat_meter Lon_meter conley_cutoff1 conley_cutoff2 polity2 irri_impact5 con_1 con_2 con_3 con_4 con_5 river100 constant, xreg(8) coord(2)
restore

preserve
drop if nomis==0
x_ols2 Lat_meter Lon_meter conley_cutoff1 conley_cutoff2 polity2 irri_impact5 con_1 con_2 con_3 con_4 con_5 oilpop2000 constant, xreg(8) coord(2)
restore

preserve
drop if nomis==0
x_ols2 Lat_meter Lon_meter conley_cutoff1 conley_cutoff2 polity2 irri_impact5 con_1 con_2 con_3 con_4 con_5 abslat_jb precavr tempavr soil12 oilpop2000 river100 constant, xreg(13) coord(2)
restore

/* Figure 2. AV plot */
reg polity2 irri_impact5 con_* abslat_jb precavr tempavr soil12	if sample==1, r
avplot irri_impact5, mlab(iso3) mcolor(gs0) plotregion(fcolor(white)) graphregion(color(white)) 

/* Table B1. Alternative irrigation measure */

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"
reg polity2 irri_impact4_5  con_*	if sample==1, r
outreg2 using irri_mainreg, label replace title(Table 3. Democracy on irrigation potential controlling for geography) drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) bdec(3) dec(3) nocons nonot
reg polity2 irri_impact4_5 con_* abslat_jb precavr tempavr soil12	if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 con_* precavr precavr_sq if e(sample), r
test precavr=precavr_sq=0
outreg2 using irri_mainreg, label drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact4_5 con_* precavr precavr_sq	if sample==1, r
test precavr=precavr_sq=0
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact4_5 con_* oilpop2000 if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact4_5 con_* river100	if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact4_5 con_* abslat_jb river100 precavr tempavr soil12 oilpop2000 if sample==1, r
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, OLS, Continent dummies, Yes) nocons bdec(3) dec(3) nonot
qreg polity2 irri_impact4_5 con_* abslat_jb river100 precavr tempavr soil12 oilpop2000 if sample==1
outreg2 using irri_mainreg, label 		drop(con_*) addtext(Estimation, Median, Continent dummies, Yes) nocons bdec(3) dec(3) nonot tex(frag)

/* Table B2. More geo */
reg polity2 irri_impact5 con_*  precavr_sq rugged landlocked_gadm malariaecology tropics_nunn area_tot precstd_year landcr_jb, r
gen sample1=e(sample)

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"
reg polity2 irri_impact5 con_* rugged if sample1 == 1, r
outreg2 using irri_mainreg2, replace title(More geo) drop(con_*) addtext(Continent dummies, Yes) bdec(2) dec(2) nocons nonot
reg polity2 irri_impact5 con_* landlocked_gadm if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 con_* malariaecology if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 land100coast con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 con_* landcr_jb if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 large_riv con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 rivershare con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 con_* precstd_year if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 elevation_mean con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label drop(con_*) addtext(Continent dummies, Yes) bdec(2) dec(2) nocons nonot
reg polity2 irri_impact5 elevation_var con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 gdays con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot tex(frag)

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"
reg polity2 irri_impact5 abslat_jb abslat_sq con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 	replace title(more geoB)	drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 agr_suit_mean con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 agr_suit_var con_* if sample1 == 1 , r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 con_* arable if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 con_* area_tot if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 con_* tropics_nunn if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 lnwheatsugar con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 lncerealcash4_2 con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 mineral_rents con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 diamond con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 salt_fraction_totland con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2 irri_impact5 tropics_nunn lncerealcash4_2 con_* area_tot arable if sample1 == 1 , r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot tex(frag)

/* Table B2 without irrigation */

reg polity2  con_* rugged if sample1 == 1, r
outreg2 using irri_mainreg2, replace title(More geo) drop(con_*) addtext(Continent dummies, Yes) bdec(2) dec(2) nocons nonot
reg polity2  con_* landlocked_gadm if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  con_* malariaecology if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  land100coast con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  con_* landcr_jb if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  large_riv con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  rivershare con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  con_* precstd_year if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  elevation_mean con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label drop(con_*) addtext(Continent dummies, Yes) bdec(2) dec(2) nocons nonot
reg polity2  elevation_var con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  gdays con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot tex(frag)

reg polity2  abslat_jb abslat_sq con_* if sample1 == 1, r
outreg2 using irri_mainreg2, label 	replace title(more geoB)	drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  agr_suit_mean con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  agr_suit_var con_* if sample1 == 1 , r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  con_* arable if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  con_* area_tot if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  con_* tropics_nunn if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  lnwheatsugar con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  lncerealcash4_2 con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  mineral_rents con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  diamond con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  salt_fraction_totland con_*  if sample1 == 1, r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot
reg polity2  tropics_nunn lncerealcash4_2 con_* area_tot arable if sample1 == 1 , r
outreg2 using irri_mainreg2, label 		drop(con_*) addtext(Continent dummies, Yes) nocons bdec(2) dec(2) nonot tex(frag)

/* Table 5. Development */

reg polity2 irri_impact5 con_* pd1500 yst colony lnrgdp democracy_headman statehist00v31, r
gen  sample2 = e(sample)

reg polity2 irri_impact5 con_* if sample2==1, r
outreg2 using irri_robustness1,  label replace title(Table 5. Democracy on irrigation potential controlling for development and colonization) drop(con_*)   addtext(Continent dummies, Yes, Geo controls, No) nocons bdec(3) dec(3)  nonot
reg polity2 irri_impact5 con_* lnrgdp if sample2==1, r
outreg2 using irri_robustness1, label drop(con_*)  addtext(Continent dummies, Yes, Geo controls, No) nocons bdec(3) dec(3)  nonot
reg polity2 irri_impact5 con_* yst if sample2==1, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No) nocons  bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* statehist00v31 if sample2==1, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No) nocons  bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* pd1500 if sample2==1, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* colony if sample2==1, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No) nocons  bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* eurfrac if sample2==1, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* democracy_headman if sample2==1, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* yst statehist00v31 lnrgdp pd1500 colony eurfrac democracy_headman, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No)  nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* yst lnrgdp pd1500 colony eurfrac, r
outreg2 using irri_robustness1, label 		drop(con_*) addtext(Continent dummies, Yes, Geo controls, No)  nocons bdec(3) dec(3) nonot tex(frag)

/*Table 6. Colonies*/

reg polity2 irri_impact5 con_*, r
replace sample1=e(sample)

reg polity2 irri_impact5 if sample1 == 1 & colony==0, r
outreg2 using irri_robustness2,  label replace title(Table 6. Democracy on irrigation potential in non-colonies vs colonies) addtext(Continent dummies, No, Former colony, No, Sample, All) bdec(3) nocons nonot
reg polity2 irri_impact5 con_* if sample1 == 1 & colony==0, r
outreg2 using irri_robustness2, label 		drop(con_*)  addtext(Continent dummies, Yes, Former colony, No, Sample, All) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* if sample1 == 1 & colony==0 & continent!="Europe", r
outreg2 using irri_robustness2, label 		drop(con_*)  addtext(Continent dummies, Yes, Former colony, No, Sample, Non-Europe) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 if sample1 == 1 & colony==1, r
outreg2 using irri_robustness2, label 		drop(con_*)  addtext(Continent dummies, No, Former colony, Yes, Sample, All) nocons bdec(3) dec(3) nonot
reg polity2 irri_impact5 con_* if sample1 == 1 & colony==1, r
outreg2 using irri_robustness2, label 		drop(con_*)  addtext(Continent dummies, Yes, Former colony, Yes, Sample, All) nocons bdec(3) dec(3) nonot 
reg polity2 irri_impact5 con_* malariaecology if sample1 == 1 & colony==1, r
outreg2 using irri_robustness2, label 		drop(con_*)  addtext(Continent dummies, Yes, Former colony, Yes, Sample, All) tex(frag) nocons bdec(3) dec(3) nonot

/* Table C1, panel B. Second stage estimates */
drop sample
gen sample=.
gen irri_table=.

label var irri_table "Irrigation"

local irri irri_actcult
quietly: ivreg2 polity2 (`irri'=irri_impact5) con_* abslat_jb precavr tempavr soil12, r ffirst
replace sample=e(sample)
replace irri_table=irri_actcult

ivreg2 polity2 (irri_table=irri_impact5) if sample==1, r ffirst
outreg2 using irri_ols, label replace title(IV country)  addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, No, Baseline geography, No, Irrigation, `irri') bdec(3) nocons nonot 
ivreg2 polity2 (irri_table=irri_impact5) con_* if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, Yes, Baseline geography, No, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot 
ivreg2 polity2 (irri_table=irri_impact5) con_* abslat_jb precavr tempavr soil12 if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, Yes, Baseline geography, Yes, Irrigation, `irri') bdec(3) nocons drop(con_* abslat_jb precavr tempavr soil12) nonot

local irri irri1900
quietly: ivreg2 polity2 (`irri'=irri_impact5) con_* abslat_jb precavr tempavr soil12, r ffirst
replace sample=e(sample)
replace irri_table=irri1900

ivreg2 polity2 (irri_table=irri_impact5) if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, No, Baseline geography, No, Irrigation, `irri') bdec(3) nocons nonot 
ivreg2 polity2 (irri_table=irri_impact5) con_* if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, Yes, Baseline geography, No, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot 
ivreg2 polity2 (irri_table=irri_impact5) con_* abslat_jb precavr tempavr soil12 if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, Yes, Baseline geography, Yes, Irrigation, `irri') bdec(3) nocons drop(con_* abslat_jb precavr tempavr soil12) nonot

local irri irri2
quietly: ivreg2 polity2 (`irri'=irri_impact5) con_* abslat_jb precavr tempavr soil12, r ffirst
replace sample=e(sample)

replace irri_table=irri2

ivreg2 polity2 (irri_table=irri_impact5) if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, No, Baseline geography, No, Irrigation, `irri') bdec(3) nocons nonot 
ivreg2 polity2 (irri_table=irri_impact5) con_* if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, Yes, Baseline geography, No, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot 
ivreg2 polity2 (irri_table=irri_impact5) con_* abslat_jb precavr tempavr soil12 if sample==1, r ffirst
outreg2 using irri_ols, label append addstat(Kleibergen Paap F, e(widstat), A Rubin p, e(archi2p)) addtext(Continent dummies, Yes, Baseline geography, Yes, Irrigation, `irri') bdec(3) nocons drop(con_* abslat_jb precavr tempavr soil12) nonot tex(frag)

/* Table C1, panel A. First stage estimates */
local irri irri_actcult
quietly: ivreg2 polity2 (`irri'=irri_impact5) con_* abslat_jb precavr tempavr soil12, r ffirst
replace sample=e(sample)

replace irri_table=irri_actcult

reg irri_table irri_impact5 if sample==1, r
outreg2 using irri_ols, label replace title(IV country) addtext(Continent dummies, No, Baseline geography, No, Irrigation, `irri') bdec(3) nocons nonot 
reg irri_table irri_impact5 con_* if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, Yes, Baseline geography, No, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot 
reg irri_table irri_impact5 con_* abslat_jb precavr tempavr soil12 if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, Yes, Baseline geography, Yes, Irrigation, `irri') bdec(3) nocons drop(con_* ) nonot

local irri irri1900
quietly: ivreg2 polity2 (`irri'=irri_impact5) con_* abslat_jb precavr tempavr soil12, r ffirst
replace sample=e(sample)

replace irri_table=irri1900

reg irri_table irri_impact5 if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, No, Baseline geography, No, Irrigation, `irri') bdec(3) nocons nonot 
reg irri_table irri_impact5 con_* if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, Yes, Baseline geography, No, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot 
reg irri_table irri_impact5 con_* abslat_jb precavr tempavr soil12 if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, Yes, Baseline geography, Yes, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot

local irri irri2
quietly: ivreg2 polity2 (`irri'=irri_impact5) con_* abslat_jb precavr tempavr soil12, r ffirst
replace sample=e(sample)
replace irri_table=irri2

reg irri_table irri_impact5 if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, No, Baseline geography, No, Irrigation, `irri') bdec(3) nocons nonot 
reg irri_table irri_impact5 con_* if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, Yes, Baseline geography, No, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot 
reg irri_table irri_impact5 con_* abslat_jb precavr tempavr soil12 if sample==1, r
outreg2 using irri_ols, label append addtext(Continent dummies, Yes, Baseline geography, Yes, Irrigation, `irri') bdec(3) nocons drop(con_*) nonot tex(frag)

/* Figure C1. AV plot*/
reg irri_actcult irri_impact5 abslat_jb precavr tempavr soil12 con_*, r
avplot irri_impact5, mlab(iso3) ytitle(Actual irrigation | X) xtitle(Irrigation potential | X) mcolor(gs0) plotregion(fcolor(white)) graphregion(color(white)) 

/*Table 7. Culture*/

reg polity2 irri_impact5 con_* if muslim00!=., r
outreg2 using irri_robustness5,  replace title(Table 7. Democracy on irrigation potential controlling for cultural values) drop(con_*) addtext(Continent dummies, Yes) nocons bdec(3) dec(3) nonot label
reg polity2 irri_impact5 con_* muslim00, r
outreg2 using irri_robustness5,  append drop(con_*) addtext(Continent dummies, Yes) nocons bdec(3) dec(3) nonot label
reg polity2 irri_impact5 con_* prot00, r
outreg2 using irri_robustness5, append drop(con_*) addtext(Continent dummies, Yes) nocons bdec(3) dec(3) nonot label
reg polity2 irri_impact5 con_* cath00, r
outreg2 using irri_robustness5, append drop(con_*) addtext(Continent dummies, Yes) nocons bdec(3) dec(3) nonot label
reg polity2 irri_impact5 con_* buddis00, r
outreg2 using irri_robustness5, append drop(con_*) addtext(Continent dummies, Yes) nocons bdec(3) dec(3) nonot label
reg polity2 irri_impact5 con_* muslim00 prot00 cath00 buddis00, r
outreg2 using irri_robustness5, append drop(con_*) addtext(Continent dummies, Yes) nocons bdec(3) dec(3) nonot label tex(frag)
qreg polity2 irri_impact5 con_* muslim00 prot00 cath00 buddis00

/*Table B3. Additional controls*/

drop sample
reg polity2 irri_impact5 ethnic religion language con_* legor_gbr legor_fra legor_soc legor_deu legor_sca km_traderoute_1100, r
gen sample=e(sample)

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"

reg polity2 irri_impact5 con_* if sample==1, r
outreg2 using robust, replace title(Additional controls) addtext(Continents, Yes) drop(arable con_* capcon_* tempavr precavr soil12 abslat_jb) bdec(2) dec(2) nonot label nocons
reg polity2 irri_impact5 ethnic religion language con_* if sample==1, r
outreg2 using robust, append addtext(Continents, Yes) drop(arable con_* capcon_* tempavr precavr soil12 abslat_jb) bdec(2) dec(2) nonot label nocons
reg polity2 irri_impact5 legor_gbr legor_fra legor_soc legor_deu legor_sca con_* if sample==1, r
outreg2 using robust, append addtext(Continents, Yes) drop(arable con_* capcon_* tempavr precavr soil12 abslat_jb) bdec(2) dec(2) nonot label nocons 
reg polity2 irri_impact5 ysi con_* if ysi>=0 & sample==1, r
outreg2 using robust, append addtext(Continents, Yes) drop(arable con_* capcon_* tempavr precavr soil12 abslat_jb) bdec(2) dec(2) nonot label nocons 
reg polity2 irri_impact5 con_* km_traderoute_1100, r
outreg2 using robust, append sortvar(irri_impact5 ethnic religion language) addtext(Continents, Yes) drop(arable con_* capcon_* tempavr precavr soil12 abslat_jb) bdec(2) dec(2) nonot label nocons tex(frag)

/*Table 11. Land inequality*/

/*First stage*/
xi: reg min_frank_landgini irri_impact5 agr_suit_var con_* i.decade, r 
local controls agr_suit_var con_* _Ideca* abslat_jb river100 precavr tempavr soil12 oilpop2000 lnwheatsugar yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00
reg `controls'
gen sampleiv=e(sample)

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"

reg min_frank_landgini irri_impact5  con_* if polity2!=. & sampleiv==1, r 
outreg2 using robust.tex, replace title(Second stage) addtext(Continents, Yes, Variance agr suitability, No, Decade fixed effects, No) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: reg min_frank_landgini irri_impact5 con_* i.decade if polity2!=. & sampleiv==1, r 
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, No, Decade fixed effects, Yes) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: reg min_frank_landgini irri_impact5 agr_suit_var con_* i.decade if polity2!=. & sampleiv==1, r 
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: reg min_frank_landgini irri_impact5 agr_suit_var con_* i.decade abslat_jb river100 precavr tempavr soil12 oilpop2000 lnwheatsugar yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00, r 
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes) bdec(3) dec(3) nonot label nocons drop(`controls') tex(frag)

/*Second stage*/
drop sampleiv
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5) agr_suit_var con_* i.decade abslat_jb precavr tempavr soil12 river100 lnwheatsugar oilpop2000 yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00, r ffirst
gen sampleiv=e(sample)

local controls agr_suit_var con_* _Ideca* abslat_jb river100 precavr tempavr soil12 oilpop2000 lnwheatsugar yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00

xi: ivreg2 polity2 (min_frank_landgini=irri_impact5) con_* if sampleiv==1, r ffirst
outreg2 using robust.tex, replace title(Second stage) addtext(Continents, Yes, Decade fixed effects, No, Agr suitability variance, No, Remaining controls, No) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5) con_* i.decade if sampleiv==1, r ffirst
outreg2 using robust.tex, append addtext(Continents, Yes, Decade fixed effects, Yes, Agr suitability variance, No, Remaining controls, No) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5) agr_suit_var con_* i.decade if sampleiv==1, r ffirst
outreg2 using robust.tex, append addtext(Continents, Yes, Decade fixed effects, Yes, Agr suitability variance, Yes, Remaining controls, No) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5) agr_suit_var con_* i.decade abslat_jb precavr tempavr soil12 river100 lnwheatsugar oilpop2000 yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00, r ffirst
outreg2 using robust.tex, append addtext(Continents, Yes, Decade fixed effects, Yes, Agr suitability variance, Yes, Remaining controls, Yes) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p)) bdec(3) dec(3) nonot label nocons drop(`controls') tex(frag)

/*Hansen*/
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5 lncerealcash4_2) con_*  if sampleiv==1, r ffirst
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, No, Decade fixed effects, No, Remaining controls, No) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p), OID p, e(jp)) bdec(3) dec(3) nonot label nocons drop(`controls')
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5 lncerealcash4_2) agr_suit_var con_* i.decade if sampleiv==1 , r ffirst
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes, Remaining controls, No) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p), OID p, e(jp)) bdec(3) dec(3) nonot label nocons drop(`controls') tex(frag)
xi: ivreg2 polity2 (min_frank_landgini=irri_impact5 lncerealcash4_2) agr_suit_var con_* i.decade abslat_jb river100 precavr tempavr soil12 oilpop2000 yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00, r ffirst
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes, Baseline geo, Yes, Remaining controls, Yes) addstat(Kleibergen Paap F, e(rkf), Anderson-Rubin p, e(archi2p), OID p, e(jp)) bdec(3) dec(3) nonot label nocons drop(`controls') tex(frag)

/*Plausibly exogenous*/
rename min_frank_landgini frank

xi: ivreg2 polity2 (frank=irri_impact5) agr_suit_var con_* i.decade abslat_jb river100 precavr tempavr soil12 oilpop2000 lnwheatsugar yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00, r ffirst

local xvar con_* i.decade 
local xvar con_* 
local xvar con_* i.decade agr_suit_var 
local xvar con_* i.decade abslat_jb river100 agr_suit_var precavr tempavr soil12 lnwheatsugar oilpop2000 yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00

xi: plausexog uci polity2 `xvar' (frank=irri_impact5), gmin(-3.8) gmax(0) level(.90) vce(robust)

xi: reg polity2 `xvar' irri_impact5 if e(sample), r

/*OLS*/
rename frank min_frank_landgini

local controls agr_suit_var con_* _Ideca* abslat_jb river100 precavr tempavr soil12 oilpop2000 lnwheatsugar yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00

reg polity2 min_frank_landgini con_* if sampleiv==1, r 
outreg2 using robust.tex, replace title(Second stage) addtext(Continents, Yes, Variance agr suitability, No, Decade fixed effects, No, Remaining controls, No) bdec(3) dec(3) nonot label nocons drop(`controls')
reg polity2 min_frank_landgini con_* i.decade if sampleiv==1 , r 
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes, Remaining controls, No)  bdec(3) dec(3) nonot label nocons drop(`controls')
reg polity2 min_frank_landgini agr_suit_var con_* i.decade if sampleiv==1 , r 
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes, Remaining controls, No)  bdec(3) dec(3) nonot label nocons drop(`controls')
reg polity2 min_frank_landgini agr_suit_var con_* i.decade abslat_jb river100 precavr tempavr soil12 oilpop2000 lnwheatsugar yst lnrgdp pd1500 colony eurfrac muslim00 prot00 cath00 buddis00, r 
outreg2 using robust.tex, append addtext(Continents, Yes, Variance agr suitability, Yes, Decade fixed effects, Yes, Remaining controls, Yes)  bdec(3) dec(3) nonot label nocons drop(`controls') tex(frag)
