cd "C:\Users\okojb\Dropbox\Irrigation\EEA submission\Data"

use ethno_data, clear

/* Table 1*/

bys irri2: tab maxic if maxic!=0
bys irri2: tab domic if domic!=0

/*Table 9*/

replace V66=. if V66==0
replace V67=. if V67==0

tab V66, gen(strat)
tab V67, gen(strat2)
replace strat2=1 if strat21==1
replace strat3=1 if strat22==1
replace strat4=1 if strat23==1
replace strat5=1 if strat24==1

collapse (mean) strat1 strat2 strat3 strat4 strat5 polity, by(country)

pwcorr polity strat*, sig

use "C:\Users\okojb\Dropbox\Irrigation\Data\Ethno_Atlas\ethno_data", clear

/*Table 10*/

areg elite irri_frac abslat soil12 V102 fragmented democracy_headman if agriculture==1, r absorb(V98)
gen sample = e(sample)

cd "C:\Users\okojb\Dropbox\Irrigation\Data\Tables"
xi: areg elite irri_frac i.century if sample == 1, r absorb(V98) cl(V98)
outreg2 using irri_strat, replace label title(Table X. OLS regressions of elite stratification on irrigation potential) drop(*century* _I* con_* ) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons  bdec(3) dec(3) nonot
xi: areg elite irri_frac i.century abslat soil12 temperature precipitation if sample==1, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* soil12 temperature precipitation abslat) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) sortvar(irri_frac V102 abslat) nocons  bdec(3) dec(3) nonot
xi: areg elite irri_frac i.century settlement if sample==1, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* con_* ) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons  bdec(3) dec(3) nonot
xi: areg elite irri_frac i.century agricultural_intensity if sample==1, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* con_* ) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons  bdec(3) dec(3) nonot
xi: areg elite irri_frac i.century centralized if sample==1, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* con_* ) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons  bdec(3) dec(3) nonot
xi: areg elite irri_frac i.century democracy_headman if sample==1, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* con_* ) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons  bdec(3) dec(3) nonot
xi: areg elite irri_frac i.century soil12 temperature precipitation abslat settlement agricultural_intensity fragmented democracy_headman if sample==1, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* soil12 temperature precipitation abslat) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) nocons  bdec(3) dec(3) nonot tex(frag)
xi: areg elite irri_frac i.century soil12 temperature precipitation abslat settlement agricultural_intensity centralized, r absorb(V98) cl(V98)
outreg2 using irri_strat, append label drop(*century* _I* soil12 temperature precipitation abslat) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) nocons  bdec(3) dec(3) nonot tex(frag)

/*Table C3*/

/*Second stage*/
xi: reg elite irri_frac abslat soil12 fragmented democracy_headman V102 i.V98 if agriculture==1, r
replace sample = e(sample)

xi: ivreg2 elite (irri2=irri_frac) i.century i.V98 if sample==1, r
outreg2 using ethnoiv, replace title(Ethno IV) label drop(con_* _I* V102) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot
xi: ivreg2 elite (irri2=irri_frac) i.V98 i.century abslat soil12 precipitation temperature if sample==1, r
outreg2 using ethnoiv, append label drop(con_* _I* abslat precipitation temperature soil12) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) sortvar(irri V102 abslat) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot 
xi: ivreg2 elite (irri2=irri_frac) i.V98 i.century settlement if sample==1, r
outreg2 using ethnoiv, append label drop(con_* _I*) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot 
xi: ivreg2 elite (irri2=irri_frac) agricultural_intensity i.century i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(con_* _I* V102) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot
xi: ivreg2 elite (irri2=irri_frac) centralized i.century i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(con_* _I* V102) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot
xi: ivreg2 elite (irri2=irri_frac) democracy_headman i.century i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(con_* _I* V102) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot
xi: ivreg2 elite (irri2=irri_frac) i.century agricultural_intensity democracy_headman abslat precipitation temperature soil12 settlement centralized i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(con_* _I* abslat precipitation temperature soil12) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot
xi: ivreg2 elite (irri2=irri_frac) i.century agricultural_intensity abslat precipitation temperature soil12 settlement centralized i.V98, r
outreg2 using ethnoiv, append label sortvar(irri2 settlement agricultural_intensity fragmented democracy_headman) drop(con_* _I* abslat precipitation temperature soil12) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) addstat(Kleibergen Paap F, e(widstat)) nocons bdec(3) dec(3) nonot tex(frag) 

/*First stage*/

xi: reg irri2 irri_frac i.century i.V98 if sample==1, r
outreg2 using ethnoiv, replace title(Ethno IV first stage) label drop(*V98* *century* con_* _I* V102) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot
xi: reg irri2 irri_frac i.century i.V98 abslat soil12 precipitation temperature if sample==1, r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I* abslat precipitation temperature soil12) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, Yes) nocons bdec(3) dec(3) nonot 
xi: reg irri2 irri_frac i.century i.V98 settlement if sample==1, r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I*) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot 
xi: reg irri2 irri_frac i.century i.V98 agricultural_intensity if sample==1, r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I*) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot 
xi: reg irri2 irri_frac i.century centralized i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I* V102 abslat precipitation temperature soil12) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot
xi: reg irri2 irri_frac i.century democracy_headman i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I* V102 abslat precipitation temperature soil12) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot
xi: reg irri2 irri_frac i.century  abslat precipitation temperature soil12 settlement centralized democracy_headman agricultural_intensity i.V98 if sample==1, r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I* abslat precipitation temperature soil12) sortvar(irri irri_frac V102 abslat) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot 
xi: reg irri2 irri_frac i.century  abslat precipitation temperature soil12 settlement centralized agricultural_intensity i.V98 if elite!=., r
outreg2 using ethnoiv, append label drop(*V98* *century* con_* _I* abslat precipitation temperature soil12) sortvar(irri irri_frac V102 abslat) addtext(55 language dummies, Yes, Century fixed effects, Yes, Geographic controls, No) nocons bdec(3) dec(3) nonot tex(frag) 


